unit MbMain;
(*
   ========================================================================
    MicroBase.
       .
   ========================================================================
         .
         
         
       " ".
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface

uses //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ExtCtrls, ComCtrls, ToolWin, Menus, ImgList,
  Buttons,
  //     " "
  DFilterMainData01, DFilterService01,
  //     "MicroBase"
  MbMainData01,
  //    "MicroBase"
  MbFileTools01, MbServiceDb01,
  //   TStringGrid
  SGridEdit01;

//========================================================================
//     
//========================================================================
type
  TFormMicroBase = class(TForm)
    Panel1: TPanel;
    EditFilterName: TEdit;
    SGridEd: TStringGrid;
    Memo1: TMemo;
    Label2: TLabel;
    LbFilterComment: TLabel;
    STextRecIndx: TStaticText;
    Label6: TLabel;
    PanelRecSelector: TPanel;
    LBoxSelector: TListBox;
    PanelCtrlRec: TPanel;
    Bevel1: TBevel;
    Label7: TLabel;
    OpenDialog1: TOpenDialog;
    ToolBarAccessREC: TToolBar;
    TBAcsRecSep1: TToolButton;
    TB2RecAdd: TToolButton;
    TBAcsRecSep2: TToolButton;
    TB2RecRefresh: TToolButton;
    TBAcsRecSep3: TToolButton;
    TB2RecDelete: TToolButton;
    EdNumRec: TEdit;
    Label9: TLabel;
    ImageList1: TImageList;
    sbtnStatMain: TSpeedButton;
    sbtnStatRestore: TSpeedButton;
    sbtnRecRestore: TSpeedButton;
    LbCtrlRec: TLabel;
    STextStat: TStaticText;
    MainMenu1: TMainMenu;
    PanelCtrlDB: TPanel;
    Bevel4: TBevel;
    LbOpenID: TLabel;
    STextOpenID: TStaticText;
    ToolBarAcsessDB: TToolBar;
    TB1Sep1: TToolButton;
    TB1OpenDB: TToolButton;
    TB1Sep2: TToolButton;
    TB1NewDB: TToolButton;
    TB1Sep3: TToolButton;
    TB1SaveDB: TToolButton;
    MMFiles: TMenuItem;
    MMNewDB: TMenuItem;
    MMOpenDB: TMenuItem;
    MMSaveDB: TMenuItem;
    MMClose: TMenuItem;
    PanelFiedRec: TPanel;
    ToolBarFields: TToolBar;
    TB3Scale: TToolButton;
    TB3Sep1: TToolButton;
    TB3Sep2: TToolButton;
    TB3Clean: TToolButton;
    TB3Sep3: TToolButton;
    TB3Random: TToolButton;
    Label1: TLabel;
    EditScale: TEdit;
    CBoxFilterType: TComboBox;
    Label5: TLabel;
    PanelExpImp: TPanel;
    sbtnImport: TSpeedButton;
    sbtnExport: TSpeedButton;
    Label4: TLabel;
    Label8: TLabel;
    stxtChangeID: TStaticText;
    CbBoxRqFilterType: TComboBox;
    LaRecType: TLabel;
    SaveDialog1: TSaveDialog;
    CheckBoxSorted: TCheckBox;
    procedure LBoxSelectorClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TB1OpenDBClick(Sender: TObject);
    procedure TB2RecAddClick(Sender: TObject);
    procedure TB2RecRefreshClick(Sender: TObject);
    procedure TB2RecDeleteClick(Sender: TObject);
    procedure sbtnRecRestoreClick(Sender: TObject);
    procedure sbtnStatMainClick(Sender: TObject);
    procedure sbtnStatRestoreClick(Sender: TObject);
    procedure TB3CleanClick(Sender: TObject);
    procedure TB3ScaleClick(Sender: TObject);
    procedure TB3RandomClick(Sender: TObject);
    procedure sbtnImportClick(Sender: TObject);
    procedure CbBoxRqFilterTypeClick(Sender: TObject);
    procedure CBoxFilterTypeClick(Sender: TObject);
    procedure EditFilterNameChange(Sender: TObject);
    procedure sbtnExportClick(Sender: TObject);
    procedure TB1SaveDBClick(Sender: TObject);
    procedure TB1NewDBClick(Sender: TObject);
    procedure MMNewDBClick(Sender: TObject);
    procedure MMOpenDBClick(Sender: TObject);
    procedure MMSaveDBClick(Sender: TObject);
    procedure MMCloseClick(Sender: TObject);
    procedure CheckBoxSortedClick(Sender: TObject);
    // ------------------------------------------
    //  onClick  StringGrid
    procedure SGEdClick(Sender: TObject);
    //  onKeyDown  StringGrid
    procedure SGEdKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    //  onExit  StringGrid
    procedure SGEdExit(Sender: TObject);
    //  onChange  Edit
    procedure EditScaleChange(Sender: TObject);

  private
    //-------------------------------------------
    //    .    .
    //       RqFileName
    function ReLoadMicroBase (RqFileName : string) : boolean;
    //      
    procedure DialogOpenMDB();
    //    ()   
    procedure DialogNewMDB();
    //   ( )    
    procedure DialogSaveMDB();
    //-------------------------------------------
    //         
    function SGEditOneDFVal
                      (Sender: TObject;
                  var  RqDFArr : TDFiltrArray;  //   
                  var  RqDFScl : integer;       //   
                  var  RqEdCB  : TSGEdCB;       //   
                       RqSGrid : TStringGrid;   // StringGrid 
                       RqSEdit : TEdit          // Edit  
                      ) : boolean;
    //      
    procedure UnDoEdMarker(RqEd : boolean);
    //-------------------------------------------
    //      
    procedure ClearFilterRecord(var RqBufRec : TFilterBuf);
    //       
    procedure ShowBufRecord (RqBufRec : TFilterBuf);
    //      
    procedure SaveBufRecord (var RqBufRec : TFilterBuf);
    //-------------------------------------------
    //           
    procedure LoadRecFromBaseToBuf (RqIndRec : integer);
    //         
    procedure LoadBaseSelector
                 (RqBase   : TMicroBase;   //   DB
                  RqStat   : byte;         //  
                  RqType   : integer);     //   
    //         
    procedure ReLoadRecSelector();
    //-------------------------------------------
  public
    // Public declarations
  end;

//========================================================================
var //  
    FormMicroBase  : TFormMicroBase;

var //  MicroBase
    MicroBase : TMicroBase;

//========================================================================
//========================================================================
implementation
{$R *.dfm}

//     
var  SGEdCB : TSGEdCB;

//========================================================================
//       
//========================================================================
// 01.02.2013
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;     //    
   Result := ExtractFileDir(Result);  //  
end;

//========================================================================
//   - 
//========================================================================
// 02.02.2013
//  
procedure TFormMicroBase.FormCreate(Sender: TObject);
begin
  // ------------------------
  //   MicroBase
  ptFRBuf := Addr(FRBuf);
  MicroBase := TMicroBase.Create(SizeOf(TFilterBuf));
  // ------------------------
  //   StringGrid Editor (unit SGridEdit01)
  InitSGridEd(SGridEd, DFilterMaxLen);
  //   SGridEd   OnSetEditText
  //SGridEd.OnSetEditText := SGridEdSetEditText;
  //     StringGrid
  SGridEd.OnClick   := SGEdClick;
  SGridEd.OnKeyDown := SGEdKeyDown;
  SGridEd.OnExit    := SGEdExit;
  // ------------------------
  //       
  TestDefaultBaseFileName(GetApplicationDirectory());
  //     
  if not TestDefaultBaseFileName (GetApplicationDirectory())
  then Self.Caption := '     !'
  else begin
    Self.Caption := '    : '
                    + ExtractFileName(WorkerFileName);
    //   
    ReLoadMicroBase (WorkerFileName);
  end;
  // ------------------------
end;
//------------------------------------------------------------------------
//  
procedure TFormMicroBase.FormDestroy(Sender: TObject);
begin
 MicroBase.Free();
 MicroBase := nil;
end;

//========================================================================
//     
//  1.   (Old Close -> New Open)
//  2.   
//  3.    ...
//========================================================================
// 02.02.2013
//    .    .
//       RqFileName
function TFormMicroBase.ReLoadMicroBase (RqFileName : string) : boolean;
begin
  Result := False;
  if Assigned(MicroBase)
  then begin
     //    ,   
     if MicroBase.OpenOk then MicroBase.CloseMicroBase;
     //    
     if MicroBase.OpenMicroBase(RqFileName)
     then begin
       sbtnStatMain.Down := True;  //    
       //    
       Self.Caption := '    : ' + ExtractFileName(RqFileName);
       //     
       LoadBaseSelector(MicroBase, rsDataRec, 0);
       STextStat.Caption := '  ';
       STextOpenID.Color := clLime;        //  -  
       LbOpenID.Caption  := ' (Open)';
       //     
       TB1SaveDB.Visible    := True;       //  
       PanelCtrlRec.Visible := True;       //   
     end
     else begin
       Self.Caption := '    : (Closed)';
       STextOpenID.Color    := clBtnFace;      //  -  
       LbOpenID.Caption     := ' (Close)';
       //     
       TB1SaveDB.Visible    := False;      //  
       PanelCtrlRec.Visible := False;      //   
     end;
  end;
end;
//------------------------------------------------------------------------
// 04.02.2013
//      
procedure TFormMicroBase.DialogOpenMDB();
begin
  //    
  OpenDialog1.InitialDir := GetApplicationDirectory() + '\'
                         + DefaultBaseDirectory;
  //     
  OpenDialog1.Filter := 'Microbase files (*.FDb)|*.FDB';
  if OpenDialog1.Execute
  then begin
       //    
       WorkerFileName := OpenDialog1.FileName;
       if FileExists(WorkerFileName)
       then ReLoadMicroBase (WorkerFileName)
       else begin
          //      
          WorkerFileName := DefaultFileName;
          ReLoadMicroBase (WorkerFileName);
       end;
  end;
end;
//------------------------------------------------------------------------
// 04.02.2013
//    ()   
procedure TFormMicroBase.DialogNewMDB();
var WName : string;  //     
begin
    //      
    WName := CreateNewDBAs (SaveDialog1, GetApplicationDirectory());
    if WName <> ''
    then begin
       //    
       if FileExists(WName)
       then begin
          if MessageDlg('     :'
               + #13#10 + ExtractFileName(WName) + ' ?',
                 mtConfirmation, [mbYes, mbNo], 0) = mrYes
          then begin
             //   Microbase  
             ReLoadMicroBase(WName);
             WorkerFileName := WName;
          end;
       end;
    end;
end;
//------------------------------------------------------------------------
// 04.02.2013
//   ( )    
procedure TFormMicroBase.DialogSaveMDB();
var WName : string;  //     
begin
    //  ( )    
    WName := SaveDBAs(MicroBase,  SaveDialog1, GetApplicationDirectory());
    if WName <> ''
    then begin
       //    
       if FileExists(WName)
       then begin
          if MessageDlg('     :'
               + #13#10 + ExtractFileName(WName) + ' ?',
                 mtConfirmation, [mbYes, mbNo], 0) = mrYes
          then begin
             //   Microbase  
             ReLoadMicroBase(WName);
             WorkerFileName := WName;
          end;
       end;
    end;
end;
//------------------------------------------------------------------------
//      
//------------------------------------------------------------------------
// 04.02.2013
//     
procedure TFormMicroBase.TB1OpenDBClick(Sender: TObject);
begin
  DialogOpenMDB();   // 
end;
procedure TFormMicroBase.MMOpenDBClick(Sender: TObject);
begin
  DialogOpenMDB();   // 
end;
//------------------------------------------------------------------------
// 04.02.2013
//    
procedure TFormMicroBase.TB1NewDBClick(Sender: TObject);
begin
  DialogNewMDB();  // 
end;
procedure TFormMicroBase.MMNewDBClick(Sender: TObject);
begin
  DialogNewMDB();  // 
end;
//------------------------------------------------------------------------
// 04.02.2013
//  ( )    
procedure TFormMicroBase.TB1SaveDBClick(Sender: TObject);
begin
  DialogSaveMDB(); // 
end;
procedure TFormMicroBase.MMSaveDBClick(Sender: TObject);
begin
  DialogSaveMDB(); // 
end;

//========================================================================
//      
//  1.    (   )
//  2.      
//========================================================================
// 02.02.2013
//       
procedure TFormMicroBase.sbtnStatMainClick(Sender: TObject);
begin
  if not Assigned(MicroBase) then Exit;
  if MicroBase.OpenOk
  then begin
    //       
    if (sbtnStatMain.Down = True)
    then begin
      //    
      LoadBaseSelector(MicroBase, rsDataRec, CbBoxRqFilterType.ItemIndex);
      STextStat.Caption := '  ';
      //    ( )
      PanelCtrlRec.Visible  := True;     //    
      ToolBarAccessREC.Enabled := True;  //   
      sbtnRecRestore.Visible := False;   //   - 
    end;
  end;
end;
//------------------------------------------------------------------------
// 02.02.2013
//        
procedure TFormMicroBase.sbtnStatRestoreClick(Sender: TObject);
begin
  if not Assigned(MicroBase) then Exit;
  if MicroBase.OpenOk
  then begin
    //     
    if (sbtnStatRestore.Down = True)
    then begin
      //    
      LoadBaseSelector(MicroBase, rsDeletedRec, CbBoxRqFilterType.ItemIndex);
      STextStat.Caption := '  ';
      //    ( )
      PanelCtrlRec.Visible  := False;     //    
      ToolBarAccessREC.Enabled := False;  //   
      sbtnRecRestore.Visible := True;     //   - 
    end;
  end;
end;

//========================================================================
//
//    , ,   .
//   (      )
//
//========================================================================
//------------------------------------------------------------------------
//           
//------------------------------------------------------------------------
// 03.02.2013
//       
procedure ClearFilter(var RqBufRec : TFilterBuf);
var wRow, wCol : integer;
begin
   for wRow := Low(RqBufRec.Filter) to High(RqBufRec.Filter)
   do for wCol := Low(RqBufRec.Filter[wRow]) to High(RqBufRec.Filter[wRow])
      do RqBufRec.Filter[wRow, wCol] := 0;
end;
//------------------------------------------------------------------------
// 03.02.2013
//      
procedure TFormMicroBase.ClearFilterRecord(var RqBufRec : TFilterBuf);
var wInd : byte;
begin
   RqBufRec.Name := '  ';
   ClearFilter(RqBufRec);
   with RqBufRec
   do begin
     Scale := 1; //   
     //      ( )
     Filter[High(Filter) div 2, High(Filter[0]) div 2] := 1;
     //       
     FRBuf.FType := CbBoxRqFilterType.ItemIndex;
     //  
     for wInd := Low(Comment) to High(Comment)
     do Comment[wInd]:='';
   end;
end;
//------------------------------------------------------------------------
// 03.02.2013
//       
procedure TFormMicroBase.SaveBufRecord (var RqBufRec : TFilterBuf);
var IndCol : byte;
begin
   RqBufRec.Name := EditFilterName.Text;
   for IndCol:= Low(RqBufRec.Comment) to High(RqBufRec.Comment)
   do RqBufRec.Comment[IndCol] := Memo1.Lines[IndCol];
   //     
   //       
   //    
end;
//------------------------------------------------------------------------
// 02.02.2013
//     (      )
procedure TFormMicroBase.ShowBufRecord (RqBufRec : TFilterBuf);
var IndRow, IndCol : byte;  FVal : integer;
begin
   //   
   EditFilterName.Text := RqBufRec.Name;
   //   
   EditScale.Text := IntToStr(RqBufRec.Scale);
   //   
   for IndRow:= 0 to High(RqBufRec.Filter) do
   begin
     for IndCol:= 0 to High(RqBufRec.Filter[IndRow]) do
     begin
       FVal := RqBufRec.Filter[IndRow, IndCol];
       if FVal <> 0
       then SGridEd.Cells[IndCol, IndRow]:= IntToStr(FVal)
       else SGridEd.Cells[IndCol, IndRow]:= '';
     end;
   end;
   //   
   CBoxFilterType.ItemIndex := RqBufRec.FType;
   //   
   Memo1.Clear;
   for IndCol:= Low(RqBufRec.Comment) to High(RqBufRec.Comment)
   do Memo1.Lines.Add(RqBufRec.Comment[IndCol]);
end;
//------------------------------------------------------------------------
// 03.02.2013
//       
function GetRecIndexFromBox (RqBox : TListBox) : integer;
begin
  Result := -1;
  //     
  if RqBox.ItemIndex >= 0
  then begin
     //        
     Result := RqBox.ItemIndex;
     Result := Integer(RqBox.Items.Objects[Result]);
  end;
end;
//------------------------------------------------------------------------
// 03.02.2013
//           
procedure TFormMicroBase.LoadRecFromBaseToBuf (RqIndRec : integer);
begin
  if (RqIndRec >= 0) and Assigned(MicroBase) and Assigned(ptFRBuf)
  then begin
     MicroBase.ReadRecFromFile(RqIndRec);
     //      
     if MicroBase.GetRecDat(Addr(FRBuf))
     then begin
        STextRecIndx.Caption := IntToStr(MicroBase.RecIndx);
        ShowBufRecord (FRBuf);
     end;
     //   " "
     stxtChangeID.Color := clBtnFace;
  end;
end;
//------------------------------------------------------------------------
//      ()    
//------------------------------------------------------------------------
// 05.02.2013
//         
procedure TFormMicroBase.LoadBaseSelector
                 (RqBase   : TMicroBase;   //   DB
                  RqStat   : byte;         //  
                  RqType   : integer);     //   
//
var PDat    : pointer;  //       MicroBase
    RqIndx  : integer;  //   
begin
  //  
  LBoxSelector.Clear;
  //  
  if CheckBoxSorted.Checked
  then LBoxSelector.Sorted := True
  else LBoxSelector.Sorted := False;
  //  
  if Assigned(RqBase)
  then begin
     //     
     RqIndx := 0;
     PDat := RqBase.ReadRecFromFile(RqIndx);
     //    
     while PDat <> nil
     do begin
        //   
        //       RqStat
        if (RqBase.RecStat = RqStat)
        then begin
           //       RqType
           with  TFilterBuf(PDat^) do
           begin
              if (RqType <= 0)        //    
              then begin
                 //         
                 LBoxSelector.Items.AddObject
                             (Name, Pointer(MicroBase.RecIndx));
              end
              else begin
                 if (RqType = FType)  //    
                 then begin
                   //         
                   LBoxSelector.Items.AddObject
                             (Name, Pointer(MicroBase.RecIndx));
                 end;
              end;
           end;
        end;
        //      
        RqIndx := RqIndx + 1;
        PDat := RqBase.ReadRecFromFile(RqIndx);
     end;
  end;
  //    
  EdNumRec.Text := IntToStr(LBoxSelector.Count);
  //         
  if LBoxSelector.Count > 0
  then begin
       //     
      LBoxSelector.ItemIndex := 0;
      //           
      LoadRecFromBaseToBuf(GetRecIndexFromBox(LBoxSelector));
  end
  else begin
      //      
      // (      )
      ClearFilterRecord(FRBuf);
  end;
  //    
  ShowBufRecord(FRBuf);
end;

//------------------------------------------------------------------------
// 05.02.2013
//         
procedure TFormMicroBase.ReLoadRecSelector();
begin
  //  
  if sbtnStatMain.Down and (not sbtnStatRestore.Down)
  then //   
      LoadBaseSelector(MicroBase, rsDataRec, CbBoxRqFilterType.ItemIndex)
  else //   
      LoadBaseSelector(MicroBase, rsDeletedRec, CbBoxRqFilterType.ItemIndex);
end;
//------------------------------------------------------------------------
// 05.02.2013
//   
procedure TFormMicroBase.CheckBoxSortedClick(Sender: TObject);
begin
  //         
  ReLoadRecSelector();
end;
//------------------------------------------------------------------------
// 05.02.2013
//       
procedure TFormMicroBase.CbBoxRqFilterTypeClick(Sender: TObject);
begin
   //         
  ReLoadRecSelector();
end;

//------------------------------------------------------------------------
//          
//------------------------------------------------------------------------
// 03.02.2013
//         
procedure TFormMicroBase.LBoxSelectorClick(Sender: TObject);
var wIndx : integer;
begin
  wIndx := GetRecIndexFromBox(LBoxSelector);
  if (wIndx >= 0) and Assigned(MicroBase) and Assigned(ptFRBuf)
  then begin
     MicroBase.ReadRecFromFile(wIndx);
     //      
     if MicroBase.GetRecDat(ptFRBuf)
     then begin
        //      
        STextRecIndx.Caption := IntToStr(MicroBase.RecIndx);
        ShowBufRecord (FRBuf);
     end;
     //   " "
     stxtChangeID.Color := clBtnFace;
  end;
end;
//------------------------------------------------------------------------
//        (   )
//------------------------------------------------------------------------
// 03.02.2013
//        (  )
function WriteFilter (RqBase  : TMicroBase;  //    
                      RqIndx  : integer;     //    
                      RqPBuf  : pointer;     //    
                      RqStat  : byte ): boolean;
begin
  Result := False;
  if Assigned(RqBase) and (RqIndx >= 0) and (RqPBuf <> nil)
  then begin
     //   
     if (RqStat = rsDeletedRec) or (RqStat = rsDataRec)
     then begin
        //    MicroBase    
        if RqBase.SetRecDat(RqPBuf)
        then begin
           //  (  )   
           if RqBase.WriteRecToFile(RqStat, RqIndx)
           then Result := True;
        end;
     end;
  end;
end;

//========================================================================
//
//   ,    
//      (     )
//
//========================================================================
// 03.02.2013
//       
procedure TFormMicroBase.TB2RecAddClick(Sender: TObject);
var PDat : pointer;
begin
   if Assigned(MicroBase)
   then begin
      PDat := Addr(FRBuf);
      if MicroBase.SetRecDat(PDat)
      then begin
         MicroBase.AddRecToFile;
         //   " "
         stxtChangeID.Color := clBtnFace;
         //     
         LoadBaseSelector(MicroBase, rsDataRec, CbBoxRqFilterType.ItemIndex);
         //   ListBox   
         if LBoxSelector.Count > 0
         then begin
            //     
            LBoxSelector.ItemIndex := LBoxSelector.Count - 1;
            //        
            LBoxSelectorClick(nil);
         end;
      end;
   end;
end;
//------------------------------------------------------------------------
//          
//------------------------------------------------------------------------
// 03.02.2013
//     ,   
procedure TFormMicroBase.TB2RecRefreshClick(Sender: TObject);
var wIndx : integer;
begin
  //        
  if (LBoxSelector.Count > 0) and (LBoxSelector.ItemIndex >= 0)
  then begin
     //        
     wIndx := GetRecIndexFromBox(LBoxSelector);
     if wIndx >= 0
     then begin
       //         Microbase
       SaveBufRecord (FRBuf);
       //     wIndx    (rsDataRec)
       if WriteFilter(MicroBase, wIndx, ptFRBuf, rsDataRec)
       then begin
         //      
         LBoxSelector.Items[LBoxSelector.ItemIndex]:= EditFilterName.Text;
         //   " "
         stxtChangeID.Color := clBtnFace;
       end;
     end;
  end
  else begin
     MessageDlg('      ...',
                 mtWarning, [mbOk], 0);
  end;
end;
//------------------------------------------------------------------------
//      
//     ,     
//   .       .
//------------------------------------------------------------------------
// 03.02.2013
//   ,   
procedure TFormMicroBase.TB2RecDeleteClick(Sender: TObject);
var wIndx : integer;
begin
  //        
  if (LBoxSelector.Count > 0) and (LBoxSelector.ItemIndex >= 0)
  then begin
     //        
     wIndx := GetRecIndexFromBox(LBoxSelector);
     if wIndx >= 0
     then begin
       //         Microbase
       SaveBufRecord (FRBuf);
       //     wIndx    (rsDeletedRec)
       if WriteFilter(MicroBase, wIndx, ptFRBuf, rsDeletedRec)
       then begin
         //   " "
         stxtChangeID.Color := clBtnFace;
       end;
       //     
       LoadBaseSelector(MicroBase, rsDataRec, CbBoxRqFilterType.ItemIndex);
     end;
  end
  else begin
     MessageDlg('      ...',
                 mtWarning, [mbOk], 0);
  end;
end;

//========================================================================
//     
//========================================================================
// 03.02.2013
//    ,   
procedure TFormMicroBase.sbtnRecRestoreClick(Sender: TObject);
var wIndx : integer;
begin
  //    
  if (sbtnStatMain.Down = False) and (sbtnStatRestore.Down = True)
  then begin
     //     
     wIndx := GetRecIndexFromBox(LBoxSelector);
     if wIndx >= 0
     then begin
       SaveBufRecord (FRBuf);
       //       
       if WriteFilter(MicroBase, wIndx, ptFRBuf, rsDataRec)
       then LoadBaseSelector
                (MicroBase, rsDeletedRec, CbBoxRqFilterType.ItemIndex);
     end;
  end;
end;

//========================================================================
//
//        
//
//========================================================================
//------------------------------------------------------------------------
//   
//------------------------------------------------------------------------
//
//   
//        
function ProStrToFloat (RqStr : string; var RqFloat : double) : boolean;
begin
  Result  := False;
  try
    if RqStr <> ''
    then RqFloat := StrToFloat(RqStr)
    else RqFloat := 0;
    Result  := True;
  except
      MessageDlg('    : ' + RqStr
                +   #13#10
                + '    .',
                mtWarning, [mbOk], 0);
  end;
end;
//------------------------------------------------------------------------
// 03.02.2013
//        
function ProStrToInt (RqStr : string; var RqInt : integer) : boolean;
begin
  Result  := False;
  try
    if RqStr <> ''
    then RqInt := StrToInt(RqStr)
    else RqInt := 0;
    Result := True;
  except
     MessageDlg('    : ' + RqStr
                +   #13#10
                + '    .',
                mtWarning, [mbOk], 0);
  end;
end;
//------------------------------------------------------------------------
// 03.02.2013
//    
function CalcScale(var RqBufRec : TFilterBuf) : integer;
var wRow, wCol : byte;
    Sum : integer;
begin
   Sum := 0;
   for wRow := Low(RqBufRec.Filter) to High(RqBufRec.Filter)
   do for wCol := Low(RqBufRec.Filter[wRow]) to High(RqBufRec.Filter[wRow])
      do Sum := Sum + RqBufRec.Filter[wRow, wCol];
   //  
   if Sum <= 0 then Sum := 1;
   Result := Sum;
end;
//------------------------------------------------------------------------
// 03.02.2013
//    
procedure SetRandomFilter(RqFilter : integer; var RqBufRec : TFilterBuf);
var FRow,  FCol,              //    
    wRow,  wCol,              //    
    DRow,  DCol,              //    
    Dist,                     //   
    Coeff  : integer;         //  
begin
   Randomize;
   //   
   FRow  := High(RqBufRec.Filter)    div 2;
   FCol  := High(RqBufRec.Filter[0]) div 2;
   //      
   RqBufRec.Filter[FRow, FCol] := (FRow + FCol) + Random(FRow + FCol);
   //   
   for wRow := 0 to High(RqBufRec.Filter) do
   begin
     //     
     DRow := Abs(wRow - FRow);
     for wCol := 0 to High(RqBufRec.Filter[wRow])
     do begin
        //     
        DCol := Abs(wCol - FCol);
        //   ,  
        if (wRow <> FRow) and (wCol <> FCol)
        then begin
            //   
            Dist := DRow + DCol;
            //  
            Dist := Abs((FRow + FCol) - Dist);
            //   
            Coeff := Random(Dist + 1);
            //      
            case RqFilter of
             0 :  RqBufRec.Filter[wRow, wCol] :=   Coeff;  //  
             1 :  RqBufRec.Filter[wRow, wCol] := - Coeff;  //  
             2 :  if Random(2) > 0                         //  
                  then RqBufRec.Filter[wRow, wCol] :=   Coeff
                  else RqBufRec.Filter[wRow, wCol] := - Coeff;
            else RqBufRec.Filter[wRow, wCol] := 0;
            end;
        end;
     end;
   end;
end;


//========================================================================
// StringGrid -    
//========================================================================
// 22.02.2013
//         
function TFormMicroBase.SGEditOneDFVal
                        (Sender: TObject;
                    var  RqDFArr : TDFiltrArray;  //   
                    var  RqDFScl : integer;       //   
                    var  RqEdCB  : TSGEdCB;       //   
                         RqSGrid : TStringGrid;   // StringGrid 
                         RqSEdit : TEdit          // Edit  
                         ) : boolean;
begin
   Result := False;
   with RqEdCB do
   begin
     //   StringGrid      
     NTxt := RqSGrid.Cells[SCol, SRow];
     //        
     SInt := RqDFArr[SRow, SCol];
     SScl := RqDFScl;
     //      
     if SGCellToInt(Sender, SCol, SRow, NTxt, NInt, ECode)
     then begin
        //        
        //        
        if NInt <> SInt
        then begin
           //      
           RqDFArr[SRow, SCol] := NInt;
           //      
           NScl := CalcDFScale(RqDFArr);
           if NScl > 0  //   
           then begin
              //    
              RqDFScl := NScl;
              //  
              ShowDFiltrScale(RqSEdit, RqDFScl);
              //     
              SRow := NRow;
              SCol := NCol;
              //   
              fRE    := False;  //    
              Result := True;   //  
           end
           else begin
              //    
              MessageDlg('    .'
                       + #13#10
                       + '   .',
                        mtWarning, [mbOk], 0);
              //      
              RqDFArr[SRow, SCol] := SInt;
              //      StringGrid
              if SInt <> 0
              then RqSGrid.Cells[SCol, SRow] := IntToStr(SInt)
              else RqSGrid.Cells[SCol, SRow] := '';
              //      
              fRE := True;
           end;
        end
        else begin
           //       
           fRE    := False;    //    
           Result := True;     //  
        end;
     end
     else begin
        //      
        RqDFArr[SRow, SCol] := SInt;
        //      StringGrid
        if SInt <> 0
        then RqSGrid.Cells[SCol, SRow] := IntToStr(SInt)
        else RqSGrid.Cells[SCol, SRow] := '';
        //      
        fRE := True;
     end;
   end;
end;

//-------------------------------------------------------------------------
// 22.02.2013
//      
procedure TFormMicroBase.UnDoEdMarker(RqEd : boolean);
begin
  with SGEdCB do
  begin
     SGridEd.Row := SRow;
     SGridEd.Col := SCol;
     NRow := SRow;
     NCol := SCol;
     fMv := False;     //    
     if RqEd
     then begin
       //      
       SGridEd.EditorMode := True;
       EdM := True;
     end;
  end;
end;
//-------------------------------------------------------------------------
// 22.02.2013
//     StringGrid    
//           
//        .
procedure TFormMicroBase.SGEdClick(Sender: TObject);
begin
   //   StringGrid   Click
   SGridEd.OnClick := nil;
   with SGEdCB do
   begin
      //      
      NRow := SGridEd.Row;;
      NCol := SGridEd.Col;
      //    
      if  (SRow <> NRow) or (SCol <> NCol)
      then fMv := True
      else fMv := False;
      //     
      if fMv
      then begin
         //      
         if not SGEditOneDFVal(Sender, FRBuf.Filter, FRBuf.Scale,
                               SGEdCB, SGridEd, EditScale)
         then //      
              UnDoEdMarker(False)
         else //   " "
              stxtChangeID.Color := clYellow;
      end;
      //        
      SRow := NRow;
      SCol := NCol;
      EdM  := SGridEd.EditorMode;
   end;
   //   StringGrid   Click
   SGridEd.OnClick := SGEdClick;
end;
//-------------------------------------------------------------------------
// 22.02.2013
//       ENTER ( )
procedure TFormMicroBase.SGEdKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN
  then begin
     with SGEdCB do
     begin
       if not EdM
       then begin
          //       
          NRow := SGridEd.Row;;
          NCol := SGridEd.Col;
          SRow := NRow;
          SCol := NCol;
          EdM  := True;
       end
       else begin
        //      
        if SGEditOneDFVal(Sender, FRBuf.Filter, FRBuf.Scale,
                          SGEdCB, SGridEd, EditScale)
        then //   " "
             stxtChangeID.Color := clYellow;
        EdM  := False;
       end;
     end;
  end;
end;
//-------------------------------------------------------------------------
// 22.02.2013
//       
procedure TFormMicroBase.SGEdExit(Sender: TObject);
begin
  with SGEdCB do
  begin
     if SGridEd.EditorMode
     then begin
        if not SGEditOneDFVal(Sender, FRBuf.Filter, FRBuf.Scale,
                               SGEdCB, SGridEd, EditScale)
        then //      
             UnDoEdMarker(False)
        else //   " "
             stxtChangeID.Color := clYellow;
     end;
  end;
end;
//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
// 21.02.2013
//    
procedure TFormMicroBase.EditScaleChange(Sender: TObject);
var  NewScale : integer;
begin
   if ProStrToInt(EditScale.Text, NewScale)
   then begin
      if NewScale > 0
      then begin
         //  
         FRBuf.Scale := NewScale;
         //   " "
         stxtChangeID.Color := clYellow;
      end
      else begin
         MessageDlg('    .'
                   + #13#10
                   + '   .',
                   mtWarning, [mbOk], 0);
         //    
         ShowDFiltrScale(EditScale, FRBuf.Scale);
      end;
   end
   else //    
        ShowDFiltrScale(EditScale, FRBuf.Scale);
end;
//========================================================================
//    
//========================================================================
// 03.02.2013
//    () 
procedure TFormMicroBase.TB3CleanClick(Sender: TObject);
begin
   //       
   ClearFilterRecord(FRBuf);
   //     
   ShowBufRecord (FRBuf);
   //   " "
   stxtChangeID.Color := clYellow;
end;
//------------------------------------------------------------------------
// 03.02.2013
//    
procedure TFormMicroBase.TB3ScaleClick(Sender: TObject);
begin
  FRBuf.Scale :=  CalcScale(FRBuf);
  ShowBufRecord (FRBuf);
  //   " "
  stxtChangeID.Color := clYellow;
end;
//------------------------------------------------------------------------
// 03.02.2013
//    
procedure TFormMicroBase.CBoxFilterTypeClick(Sender: TObject);
begin
   FRBuf.FType := CBoxFilterType.ItemIndex;
   //   " "
    stxtChangeID.Color := clYellow;
end;
//------------------------------------------------------------------------
// 03.02.2013
//    
procedure TFormMicroBase.EditFilterNameChange(Sender: TObject);
begin
   FRBuf.Name  := EditFilterName.Text;
   //   " "
    stxtChangeID.Color := clYellow;
end;
//------------------------------------------------------------------------
// 03.02.2013
//   
procedure TFormMicroBase.TB3RandomClick(Sender: TObject);
begin
   SetRandomFilter(CBoxFilterType.ItemIndex, FRBuf);
   FRBuf.Scale := CalcScale(FRBuf);
   ShowBufRecord (FRBuf);
   EditFilterName.Text := ' ' + IntToStr(FRBuf.Scale);
   //       
   FRBuf.FType := 0;
   CBoxFilterType.ItemIndex := FRBuf.FType;
   //   " "
   stxtChangeID.Color := clYellow;
end;

//========================================================================
//        " "
//========================================================================
// 03.02.2013
//       " "
procedure TFormMicroBase.sbtnImportClick(Sender: TObject);
var wRow, wCol : integer;
begin
   if (High(DFiltrArray) = High(FRBuf.Filter)) and
      (High(DFiltrArray[0]) = High(FRBuf.Filter[0]))
   then begin
     //      " "
     for wRow := 0 to High(DFiltrArray)
     do for wCol := 0 to High(DFiltrArray[wRow])
        do FRBuf.Filter[wRow, wCol] := DFiltrArray[wRow, wCol];
     //   
     FRBuf.Scale      := DFiltrScale;
     //    
     FRBuf.FType      := DFiltrType;
     FRBuf.Name       := ' ';
     //  
     for wRow := Low(FRBuf.Comment) to High(FRBuf.Comment)
     do FRBuf.Comment[wRow]:='';
     //    
     ShowBufRecord (FRBuf);
     //   " "
      stxtChangeID.Color := clYellow;
   end;
end;
//------------------------------------------------------------------------
// 03.02.2013
//       " "
procedure TFormMicroBase.sbtnExportClick(Sender: TObject);
var wRow, wCol : integer;
begin
   if (High(DFiltrArray) = High(FRBuf.Filter)) and
      (High(DFiltrArray[0]) = High(FRBuf.Filter[0]))
   then begin
     //      " "
     for wRow := 0 to High(DFiltrArray)
     do for wCol := 0 to High(DFiltrArray[wRow])
        do DFiltrArray[wRow, wCol] := FRBuf.Filter[wRow, wCol];
     //   
     DFiltrScale := FRBuf.Scale;
     //   
     DFiltrType  := FRBuf.FType;
     //   -  
     MbSetFilter := True;  // .  DFilterData01
     //    MicroBase
     Self.Close;
   end;
end;

// ========================================================================
//  ()  
// ========================================================================
//   
procedure TFormMicroBase.MMCloseClick(Sender: TObject);
begin
   Self.Close;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
